﻿using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (!string.IsNullOrEmpty(state.FakeResponseType))
            {
                state.ProxyAddResponseMessage = new ProxyAddResponseMessage
                {
                    ExceptionMessage = string.Format("MVI Fake Response Type {0}, Exception: {1}", state.FakeResponseType, state.ExceptionMessage),
                    ExceptionOccured = state.ExceptionOccured,
                    SerializedInstance = state.SerializedInstance
                };
            }
            else
            {
                state.ProxyAddResponseMessage = state.ExceptionOccured
                    ? new ProxyAddResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                    : new ProxyAddResponseMessage
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedInstance
                    };
            }
        }
    }
}